package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_g_c_s_p_m_Package_1_Impl implements GeneratedMarshaller<Package> {
  private Package[] EMPTY_ARRAY = new Package[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public Package[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Path Package_Path_moduleRootPath(Package instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Package::moduleRootPath;
  }-*/;

  native static void Package_Path_moduleRootPath(Package instance, Path value) /*-{
    instance.@org.guvnor.common.services.project.model.Package::moduleRootPath = value;
  }-*/;

  native static Path Package_Path_packageMainSrcPath(Package instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Package::packageMainSrcPath;
  }-*/;

  native static void Package_Path_packageMainSrcPath(Package instance, Path value) /*-{
    instance.@org.guvnor.common.services.project.model.Package::packageMainSrcPath = value;
  }-*/;

  native static Path Package_Path_packageTestSrcPath(Package instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Package::packageTestSrcPath;
  }-*/;

  native static void Package_Path_packageTestSrcPath(Package instance, Path value) /*-{
    instance.@org.guvnor.common.services.project.model.Package::packageTestSrcPath = value;
  }-*/;

  native static Path Package_Path_packageMainResourcesPath(Package instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Package::packageMainResourcesPath;
  }-*/;

  native static void Package_Path_packageMainResourcesPath(Package instance, Path value) /*-{
    instance.@org.guvnor.common.services.project.model.Package::packageMainResourcesPath = value;
  }-*/;

  native static Path Package_Path_packageTestResourcesPath(Package instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Package::packageTestResourcesPath;
  }-*/;

  native static void Package_Path_packageTestResourcesPath(Package instance, Path value) /*-{
    instance.@org.guvnor.common.services.project.model.Package::packageTestResourcesPath = value;
  }-*/;

  native static String Package_String_packageName(Package instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Package::packageName;
  }-*/;

  native static void Package_String_packageName(Package instance, String value) /*-{
    instance.@org.guvnor.common.services.project.model.Package::packageName = value;
  }-*/;

  native static String Package_String_caption(Package instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Package::caption;
  }-*/;

  native static void Package_String_caption(Package instance, String value) /*-{
    instance.@org.guvnor.common.services.project.model.Package::caption = value;
  }-*/;

  native static String Package_String_relativeCaption(Package instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Package::relativeCaption;
  }-*/;

  native static void Package_String_relativeCaption(Package instance, String value) /*-{
    instance.@org.guvnor.common.services.project.model.Package::relativeCaption = value;
  }-*/;

  public Package demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Package.class, objId);
    }
    Package entity = new Package();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "moduleRootPath": Package_Path_moduleRootPath(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "packageMainSrcPath": Package_Path_packageMainSrcPath(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "packageTestSrcPath": Package_Path_packageTestSrcPath(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "packageMainResourcesPath": Package_Path_packageMainResourcesPath(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "packageTestResourcesPath": Package_Path_packageTestResourcesPath(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "packageName": Package_String_packageName(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "caption": Package_String_caption(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "relativeCaption": Package_String_relativeCaption(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Package a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.project.model.Package") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "moduleRootPath") + "\":") + java_lang_Object.marshall(a0.getModuleRootPath(), a1)) + ",\"") + "packageMainSrcPath") + "\":") + java_lang_Object.marshall(a0.getPackageMainSrcPath(), a1)) + ",\"") + "packageTestSrcPath") + "\":") + java_lang_Object.marshall(a0.getPackageTestSrcPath(), a1)) + ",\"") + "packageMainResourcesPath") + "\":") + java_lang_Object.marshall(a0.getPackageMainResourcesPath(), a1)) + ",\"") + "packageTestResourcesPath") + "\":") + java_lang_Object.marshall(a0.getPackageTestResourcesPath(), a1)) + ",\"") + "packageName") + "\":") + java_lang_String.marshall(a0.getPackageName(), a1)) + ",\"") + "caption") + "\":") + java_lang_String.marshall(a0.getCaption(), a1)) + ",\"") + "relativeCaption") + "\":") + java_lang_String.marshall(a0.getRelativeCaption(), a1)) + "}");
  }

  private void lazyInit() {

  }
}