package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.model.Plugin;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_c_s_p_m_Plugin_1_Impl implements GeneratedMarshaller<Plugin> {
  private Plugin[] EMPTY_ARRAY = new Plugin[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public Plugin[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Plugin demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Plugin.class, objId);
    }
    Plugin entity = new Plugin();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "dependencies": a1.setAssumedElementType("org.guvnor.common.services.project.model.Dependency");
        entity.setDependencies(java_util_List.demarshall(objVal, a1));
        break;
        case "groupId": entity.setGroupId(java_lang_String.demarshall(objVal, a1));
        break;
        case "artifactId": entity.setArtifactId(java_lang_String.demarshall(objVal, a1));
        break;
        case "version": entity.setVersion(java_lang_String.demarshall(objVal, a1));
        break;
        case "extensions": entity.setExtensions(java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean Plugin_boolean_extensions(Plugin instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Plugin::extensions;
  }-*/;

  native static void Plugin_boolean_extensions(Plugin instance, boolean value) /*-{
    instance.@org.guvnor.common.services.project.model.Plugin::extensions = value;
  }-*/;

  public String marshall(Plugin a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.project.model.Plugin") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "dependencies") + "\":") + java_util_List.marshall(a0.getDependencies(), a1)) + ",\"") + "groupId") + "\":") + java_lang_String.marshall(a0.getGroupId(), a1)) + ",\"") + "artifactId") + "\":") + java_lang_String.marshall(a0.getArtifactId(), a1)) + ",\"") + "version") + "\":") + java_lang_String.marshall(a0.getVersion(), a1)) + ",\"") + "extensions") + "\":") + java_lang_Boolean.marshall(Plugin_boolean_extensions(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}