package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.guvnor.common.services.shared.metadata.model.DiscussionRecord;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.java.nio.base.version.VersionRecord;

public class Marshaller_o_g_c_s_s_m_m_Metadata_1_Impl implements GeneratedMarshaller<Metadata> {
  private Metadata[] EMPTY_ARRAY = new Metadata[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<LockInfo> org_uberfire_backend_vfs_impl_LockInfo = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public Metadata[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Path Metadata_Path_path(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::path;
  }-*/;

  native static void Metadata_Path_path(Metadata instance, Path value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::path = value;
  }-*/;

  native static Path Metadata_Path_realPath(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::realPath;
  }-*/;

  native static void Metadata_Path_realPath(Metadata instance, Path value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::realPath = value;
  }-*/;

  native static String Metadata_String_checkinComment(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::checkinComment;
  }-*/;

  native static void Metadata_String_checkinComment(Metadata instance, String value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::checkinComment = value;
  }-*/;

  native static String Metadata_String_lastContributor(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::lastContributor;
  }-*/;

  native static void Metadata_String_lastContributor(Metadata instance, String value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::lastContributor = value;
  }-*/;

  native static String Metadata_String_creator(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::creator;
  }-*/;

  native static void Metadata_String_creator(Metadata instance, String value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::creator = value;
  }-*/;

  native static Date Metadata_Date_lastModified(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::lastModified;
  }-*/;

  native static void Metadata_Date_lastModified(Metadata instance, Date value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::lastModified = value;
  }-*/;

  native static Date Metadata_Date_dateCreated(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::dateCreated;
  }-*/;

  native static void Metadata_Date_dateCreated(Metadata instance, Date value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::dateCreated = value;
  }-*/;

  native static List Metadata_List_tags(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::tags;
  }-*/;

  native static void Metadata_List_tags(Metadata instance, List<String> value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::tags = value;
  }-*/;

  native static List Metadata_List_discussion(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::discussion;
  }-*/;

  native static void Metadata_List_discussion(Metadata instance, List<DiscussionRecord> value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::discussion = value;
  }-*/;

  native static List Metadata_List_version(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::version;
  }-*/;

  native static void Metadata_List_version(Metadata instance, List<VersionRecord> value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::version = value;
  }-*/;

  native static boolean Metadata_boolean_generated(Metadata instance) /*-{
    return instance.@org.guvnor.common.services.shared.metadata.model.Metadata::generated;
  }-*/;

  native static void Metadata_boolean_generated(Metadata instance, boolean value) /*-{
    instance.@org.guvnor.common.services.shared.metadata.model.Metadata::generated = value;
  }-*/;

  public Metadata demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Metadata.class, objId);
    }
    Metadata entity = new Metadata();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "path": Metadata_Path_path(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "realPath": Metadata_Path_realPath(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "lockInfo": entity.setLockInfo(org_uberfire_backend_vfs_impl_LockInfo.demarshall(objVal, a1));
        break;
        case "checkinComment": Metadata_String_checkinComment(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "lastContributor": Metadata_String_lastContributor(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "creator": Metadata_String_creator(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "lastModified": Metadata_Date_lastModified(entity, java_util_Date.demarshall(objVal, a1));
        break;
        case "dateCreated": Metadata_Date_dateCreated(entity, java_util_Date.demarshall(objVal, a1));
        break;
        case "subject": entity.setSubject(java_lang_String.demarshall(objVal, a1));
        break;
        case "type": entity.setType(java_lang_String.demarshall(objVal, a1));
        break;
        case "externalRelation": entity.setExternalRelation(java_lang_String.demarshall(objVal, a1));
        break;
        case "externalSource": entity.setExternalSource(java_lang_String.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "tags": a1.setAssumedElementType("java.lang.String");
        Metadata_List_tags(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "discussion": a1.setAssumedElementType("org.guvnor.common.services.shared.metadata.model.DiscussionRecord");
        Metadata_List_discussion(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "version": a1.setAssumedElementType("org.uberfire.java.nio.base.version.VersionRecord");
        Metadata_List_version(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "generated": Metadata_boolean_generated(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Metadata a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.shared.metadata.model.Metadata") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + ",\"") + "realPath") + "\":") + java_lang_Object.marshall(a0.getRealPath(), a1)) + ",\"") + "lockInfo") + "\":") + org_uberfire_backend_vfs_impl_LockInfo.marshall(a0.getLockInfo(), a1)) + ",\"") + "checkinComment") + "\":") + java_lang_String.marshall(a0.getCheckinComment(), a1)) + ",\"") + "lastContributor") + "\":") + java_lang_String.marshall(a0.getLastContributor(), a1)) + ",\"") + "creator") + "\":") + java_lang_String.marshall(a0.getCreator(), a1)) + ",\"") + "lastModified") + "\":") + java_util_Date.marshall(a0.getLastModified(), a1)) + ",\"") + "dateCreated") + "\":") + java_util_Date.marshall(a0.getDateCreated(), a1)) + ",\"") + "subject") + "\":") + java_lang_String.marshall(a0.getSubject(), a1)) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "externalRelation") + "\":") + java_lang_String.marshall(a0.getExternalRelation(), a1)) + ",\"") + "externalSource") + "\":") + java_lang_String.marshall(a0.getExternalSource(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "tags") + "\":") + java_util_List.marshall(a0.getTags(), a1)) + ",\"") + "discussion") + "\":") + java_util_List.marshall(a0.getDiscussion(), a1)) + ",\"") + "version") + "\":") + java_util_List.marshall(a0.getVersion(), a1)) + ",\"") + "generated") + "\":") + java_lang_Boolean.marshall(Metadata_boolean_generated(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (org_uberfire_backend_vfs_impl_LockInfo == null) {
      org_uberfire_backend_vfs_impl_LockInfo = Marshalling.getMarshaller(LockInfo.class);
    }
  }
}