package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_c_s_s_t_TestResultMessage_1_Impl implements GeneratedMarshaller<TestResultMessage> {
  private TestResultMessage[] EMPTY_ARRAY = new TestResultMessage[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public TestResultMessage[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String TestResultMessage_String_identifier(TestResultMessage instance) /*-{
    return instance.@org.guvnor.common.services.shared.test.TestResultMessage::identifier;
  }-*/;

  native static void TestResultMessage_String_identifier(TestResultMessage instance, String value) /*-{
    instance.@org.guvnor.common.services.shared.test.TestResultMessage::identifier = value;
  }-*/;

  native static int TestResultMessage_int_runCount(TestResultMessage instance) /*-{
    return instance.@org.guvnor.common.services.shared.test.TestResultMessage::runCount;
  }-*/;

  native static void TestResultMessage_int_runCount(TestResultMessage instance, int value) /*-{
    instance.@org.guvnor.common.services.shared.test.TestResultMessage::runCount = value;
  }-*/;

  native static Long TestResultMessage_Long_runTime(TestResultMessage instance) /*-{
    return instance.@org.guvnor.common.services.shared.test.TestResultMessage::runTime;
  }-*/;

  native static void TestResultMessage_Long_runTime(TestResultMessage instance, Long value) /*-{
    instance.@org.guvnor.common.services.shared.test.TestResultMessage::runTime = value;
  }-*/;

  native static List TestResultMessage_List_failures(TestResultMessage instance) /*-{
    return instance.@org.guvnor.common.services.shared.test.TestResultMessage::failures;
  }-*/;

  native static void TestResultMessage_List_failures(TestResultMessage instance, List<Failure> value) /*-{
    instance.@org.guvnor.common.services.shared.test.TestResultMessage::failures = value;
  }-*/;

  public TestResultMessage demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TestResultMessage.class, objId);
    }
    TestResultMessage entity = new TestResultMessage();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "identifier": TestResultMessage_String_identifier(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "runCount": TestResultMessage_int_runCount(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "runTime": TestResultMessage_Long_runTime(entity, java_lang_Long.demarshall(objVal, a1));
        break;
        case "failures": a1.setAssumedElementType("org.guvnor.common.services.shared.test.Failure");
        TestResultMessage_List_failures(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(TestResultMessage a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.shared.test.TestResultMessage") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "identifier") + "\":") + java_lang_String.marshall(a0.getIdentifier(), a1)) + ",\"") + "runCount") + "\":") + java_lang_Integer.marshall(a0.getRunCount(), a1)) + ",\"") + "runTime") + "\":") + java_lang_Long.marshall(TestResultMessage_Long_runTime(a0), a1)) + ",\"") + "failures") + "\":") + java_util_List.marshall(a0.getFailures(), a1)) + "}");
  }

  private void lazyInit() {

  }
}