package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.messageconsole.events.UnpublishMessagesEvent;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_m_e_UnpublishMessagesEvent_1_Impl implements GeneratedMarshaller<UnpublishMessagesEvent> {
  private UnpublishMessagesEvent[] EMPTY_ARRAY = new UnpublishMessagesEvent[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public UnpublishMessagesEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public UnpublishMessagesEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(UnpublishMessagesEvent.class, objId);
    }
    UnpublishMessagesEvent entity = new UnpublishMessagesEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "sessionId": entity.setSessionId(java_lang_String.demarshall(objVal, a1));
        break;
        case "userId": entity.setUserId(java_lang_String.demarshall(objVal, a1));
        break;
        case "messageType": entity.setMessageType(java_lang_String.demarshall(objVal, a1));
        break;
        case "messagesToUnpublish": a1.setAssumedElementType("org.guvnor.messageconsole.events.SystemMessage");
        entity.setMessagesToUnpublish(java_util_List.demarshall(objVal, a1));
        break;
        case "showSystemConsole": entity.setShowSystemConsole(java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean UnpublishMessagesEvent_boolean_showSystemConsole(UnpublishMessagesEvent instance) /*-{
    return instance.@org.guvnor.messageconsole.events.UnpublishMessagesEvent::showSystemConsole;
  }-*/;

  native static void UnpublishMessagesEvent_boolean_showSystemConsole(UnpublishMessagesEvent instance, boolean value) /*-{
    instance.@org.guvnor.messageconsole.events.UnpublishMessagesEvent::showSystemConsole = value;
  }-*/;

  public String marshall(UnpublishMessagesEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.messageconsole.events.UnpublishMessagesEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "sessionId") + "\":") + java_lang_String.marshall(a0.getSessionId(), a1)) + ",\"") + "userId") + "\":") + java_lang_String.marshall(a0.getUserId(), a1)) + ",\"") + "messageType") + "\":") + java_lang_String.marshall(a0.getMessageType(), a1)) + ",\"") + "messagesToUnpublish") + "\":") + java_util_List.marshall(a0.getMessagesToUnpublish(), a1)) + ",\"") + "showSystemConsole") + "\":") + java_lang_Boolean.marshall(UnpublishMessagesEvent_boolean_showSystemConsole(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}