package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.Set;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.model.JarListPageRow;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_g_m_m_JarListPageRow_1_Impl implements GeneratedMarshaller<JarListPageRow> {
  private JarListPageRow[] EMPTY_ARRAY = new JarListPageRow[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  public JarListPageRow[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String JarListPageRow_String_repository(JarListPageRow instance) /*-{
    return instance.@org.guvnor.m2repo.model.JarListPageRow::repository;
  }-*/;

  native static void JarListPageRow_String_repository(JarListPageRow instance, String value) /*-{
    instance.@org.guvnor.m2repo.model.JarListPageRow::repository = value;
  }-*/;

  public JarListPageRow demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(JarListPageRow.class, objId);
    }
    JarListPageRow entity = new JarListPageRow();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "path": entity.setPath(java_lang_String.demarshall(objVal, a1));
        break;
        case "gav": entity.setGav((GAV) ((ObjectMarshaller) java_lang_Object).demarshall(GAV.class, objVal, a1));
        break;
        case "lastModified": entity.setLastModified(java_util_Date.demarshall(objVal, a1));
        break;
        case "repository": JarListPageRow_String_repository(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(JarListPageRow a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.m2repo.model.JarListPageRow") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "path") + "\":") + java_lang_String.marshall(a0.getPath(), a1)) + ",\"") + "gav") + "\":") + java_lang_Object.marshall(a0.getGav(), a1)) + ",\"") + "lastModified") + "\":") + java_util_Date.marshall(a0.getLastModified(), a1)) + ",\"") + "repository") + "\":") + java_lang_String.marshall(JarListPageRow_String_repository(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}