package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.m2repo.preferences.ArtifactRepositoryPreference;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_m_p_ArtifactRepositoryPreference_1_Impl implements GeneratedMarshaller<ArtifactRepositoryPreference> {
  private ArtifactRepositoryPreference[] EMPTY_ARRAY = new ArtifactRepositoryPreference[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public ArtifactRepositoryPreference[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ArtifactRepositoryPreference demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ArtifactRepositoryPreference.class, objId);
    }
    ArtifactRepositoryPreference entity = new ArtifactRepositoryPreference();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "globalM2RepoDir": entity.setGlobalM2RepoDir(java_lang_String.demarshall(objVal, a1));
        break;
        case "globalM2RepoDirEnabled": entity.setGlobalM2RepoDirEnabled(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "workspaceM2RepoDir": entity.setWorkspaceM2RepoDir(java_lang_String.demarshall(objVal, a1));
        break;
        case "workspaceM2RepoDirEnabled": entity.setWorkspaceM2RepoDirEnabled(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "distributionManagementM2RepoDirEnabled": entity.setDistributionManagementM2RepoDirEnabled(java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean ArtifactRepositoryPreference_boolean_globalM2RepoDirEnabled(ArtifactRepositoryPreference instance) /*-{
    return instance.@org.guvnor.m2repo.preferences.ArtifactRepositoryPreference::globalM2RepoDirEnabled;
  }-*/;

  native static void ArtifactRepositoryPreference_boolean_globalM2RepoDirEnabled(ArtifactRepositoryPreference instance, boolean value) /*-{
    instance.@org.guvnor.m2repo.preferences.ArtifactRepositoryPreference::globalM2RepoDirEnabled = value;
  }-*/;

  native static boolean ArtifactRepositoryPreference_boolean_workspaceM2RepoDirEnabled(ArtifactRepositoryPreference instance) /*-{
    return instance.@org.guvnor.m2repo.preferences.ArtifactRepositoryPreference::workspaceM2RepoDirEnabled;
  }-*/;

  native static void ArtifactRepositoryPreference_boolean_workspaceM2RepoDirEnabled(ArtifactRepositoryPreference instance, boolean value) /*-{
    instance.@org.guvnor.m2repo.preferences.ArtifactRepositoryPreference::workspaceM2RepoDirEnabled = value;
  }-*/;

  native static boolean ArtifactRepositoryPreference_boolean_distributionManagementM2RepoDirEnabled(ArtifactRepositoryPreference instance) /*-{
    return instance.@org.guvnor.m2repo.preferences.ArtifactRepositoryPreference::distributionManagementM2RepoDirEnabled;
  }-*/;

  native static void ArtifactRepositoryPreference_boolean_distributionManagementM2RepoDirEnabled(ArtifactRepositoryPreference instance, boolean value) /*-{
    instance.@org.guvnor.m2repo.preferences.ArtifactRepositoryPreference::distributionManagementM2RepoDirEnabled = value;
  }-*/;

  public String marshall(ArtifactRepositoryPreference a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.m2repo.preferences.ArtifactRepositoryPreference") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "globalM2RepoDir") + "\":") + java_lang_String.marshall(a0.getGlobalM2RepoDir(), a1)) + ",\"") + "globalM2RepoDirEnabled") + "\":") + java_lang_Boolean.marshall(ArtifactRepositoryPreference_boolean_globalM2RepoDirEnabled(a0), a1)) + ",\"") + "workspaceM2RepoDir") + "\":") + java_lang_String.marshall(a0.getWorkspaceM2RepoDir(), a1)) + ",\"") + "workspaceM2RepoDirEnabled") + "\":") + java_lang_Boolean.marshall(ArtifactRepositoryPreference_boolean_workspaceM2RepoDirEnabled(a0), a1)) + ",\"") + "distributionManagementM2RepoDirEnabled") + "\":") + java_lang_Boolean.marshall(ArtifactRepositoryPreference_boolean_distributionManagementM2RepoDirEnabled(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}