package org.jboss.errai.marshalling.client.api;

import org.guvnor.messageconsole.utils.CSVConverter;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_m_u_CSVConverter_1_Impl implements GeneratedMarshaller<CSVConverter> {
  private CSVConverter[] EMPTY_ARRAY = new CSVConverter[0];
  public CSVConverter[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public CSVConverter demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(CSVConverter.class, objId);
    }
    CSVConverter entity = new CSVConverter();
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(CSVConverter a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.messageconsole.utils.CSVConverter") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + (((("" + ",\"") + "^InstantiateOnly") + "\":true") + "}");
  }

  private void lazyInit() {

  }
}