package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.structure.navigator.DataContent;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_g_s_n_DataContent_1_Impl implements GeneratedMarshaller<DataContent> {
  private DataContent[] EMPTY_ARRAY = new DataContent[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public DataContent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static boolean DataContent_boolean_isDirectory(DataContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.DataContent::isDirectory;
  }-*/;

  native static void DataContent_boolean_isDirectory(DataContent instance, boolean value) /*-{
    instance.@org.guvnor.structure.navigator.DataContent::isDirectory = value;
  }-*/;

  native static String DataContent_String_lastMessage(DataContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.DataContent::lastMessage;
  }-*/;

  native static void DataContent_String_lastMessage(DataContent instance, String value) /*-{
    instance.@org.guvnor.structure.navigator.DataContent::lastMessage = value;
  }-*/;

  native static String DataContent_String_lastCommiter(DataContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.DataContent::lastCommiter;
  }-*/;

  native static void DataContent_String_lastCommiter(DataContent instance, String value) /*-{
    instance.@org.guvnor.structure.navigator.DataContent::lastCommiter = value;
  }-*/;

  native static String DataContent_String_lastCommiterEmail(DataContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.DataContent::lastCommiterEmail;
  }-*/;

  native static void DataContent_String_lastCommiterEmail(DataContent instance, String value) /*-{
    instance.@org.guvnor.structure.navigator.DataContent::lastCommiterEmail = value;
  }-*/;

  native static String DataContent_String_age(DataContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.DataContent::age;
  }-*/;

  native static void DataContent_String_age(DataContent instance, String value) /*-{
    instance.@org.guvnor.structure.navigator.DataContent::age = value;
  }-*/;

  native static Path DataContent_Path_path(DataContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.DataContent::path;
  }-*/;

  native static void DataContent_Path_path(DataContent instance, Path value) /*-{
    instance.@org.guvnor.structure.navigator.DataContent::path = value;
  }-*/;

  public DataContent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataContent.class, objId);
    }
    DataContent entity = new DataContent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "isDirectory": DataContent_boolean_isDirectory(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "lastMessage": DataContent_String_lastMessage(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "lastCommiter": DataContent_String_lastCommiter(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "lastCommiterEmail": DataContent_String_lastCommiterEmail(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "age": DataContent_String_age(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "path": DataContent_Path_path(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DataContent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.navigator.DataContent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "isDirectory") + "\":") + java_lang_Boolean.marshall(DataContent_boolean_isDirectory(a0), a1)) + ",\"") + "lastMessage") + "\":") + java_lang_String.marshall(a0.getLastMessage(), a1)) + ",\"") + "lastCommiter") + "\":") + java_lang_String.marshall(a0.getLastCommiter(), a1)) + ",\"") + "lastCommiterEmail") + "\":") + java_lang_String.marshall(a0.getLastCommiterEmail(), a1)) + ",\"") + "age") + "\":") + java_lang_String.marshall(a0.getAge(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + "}");
  }

  private void lazyInit() {

  }
}