package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.structure.navigator.DataContent;
import org.guvnor.structure.navigator.NavigatorContent;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_g_s_n_NavigatorContent_1_Impl implements GeneratedMarshaller<NavigatorContent> {
  private NavigatorContent[] EMPTY_ARRAY = new NavigatorContent[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public NavigatorContent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String NavigatorContent_String_repoName(NavigatorContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.NavigatorContent::repoName;
  }-*/;

  native static void NavigatorContent_String_repoName(NavigatorContent instance, String value) /*-{
    instance.@org.guvnor.structure.navigator.NavigatorContent::repoName = value;
  }-*/;

  native static Path NavigatorContent_Path_root(NavigatorContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.NavigatorContent::root;
  }-*/;

  native static void NavigatorContent_Path_root(NavigatorContent instance, Path value) /*-{
    instance.@org.guvnor.structure.navigator.NavigatorContent::root = value;
  }-*/;

  native static List NavigatorContent_List_breadcrumbs(NavigatorContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.NavigatorContent::breadcrumbs;
  }-*/;

  native static void NavigatorContent_List_breadcrumbs(NavigatorContent instance, List<Path> value) /*-{
    instance.@org.guvnor.structure.navigator.NavigatorContent::breadcrumbs = value;
  }-*/;

  native static List NavigatorContent_List_content(NavigatorContent instance) /*-{
    return instance.@org.guvnor.structure.navigator.NavigatorContent::content;
  }-*/;

  native static void NavigatorContent_List_content(NavigatorContent instance, List<DataContent> value) /*-{
    instance.@org.guvnor.structure.navigator.NavigatorContent::content = value;
  }-*/;

  public NavigatorContent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NavigatorContent.class, objId);
    }
    NavigatorContent entity = new NavigatorContent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "repoName": NavigatorContent_String_repoName(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "root": NavigatorContent_Path_root(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "breadcrumbs": a1.setAssumedElementType("org.uberfire.backend.vfs.Path");
        NavigatorContent_List_breadcrumbs(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "content": a1.setAssumedElementType("org.guvnor.structure.navigator.DataContent");
        NavigatorContent_List_content(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(NavigatorContent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.navigator.NavigatorContent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "repoName") + "\":") + java_lang_String.marshall(a0.getRepoName(), a1)) + ",\"") + "root") + "\":") + java_lang_Object.marshall(a0.getRoot(), a1)) + ",\"") + "breadcrumbs") + "\":") + java_util_List.marshall(a0.getBreadcrumbs(), a1)) + ",\"") + "content") + "\":") + java_util_List.marshall(a0.getContent(), a1)) + "}");
  }

  private void lazyInit() {

  }
}