package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_s_o_c_BranchPermissions_1_Impl implements GeneratedMarshaller<BranchPermissions> {
  private BranchPermissions[] EMPTY_ARRAY = new BranchPermissions[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public BranchPermissions[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public BranchPermissions demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(BranchPermissions.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("branchName"), a1);
    a1.setAssumedMapKeyType("java.lang.String");
    a1.setAssumedMapValueType("org.guvnor.structure.organizationalunit.config.RolePermissions");
    final Map c1 = java_util_Map.demarshall(obj.get("permissionsByRole"), a1);
    a1.resetAssumedTypes();
    BranchPermissions entity = new BranchPermissions(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(BranchPermissions a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.organizationalunit.config.BranchPermissions") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "branchName") + "\":") + java_lang_String.marshall(a0.getBranchName(), a1)) + ",\"") + "permissionsByRole") + "\":") + java_util_Map.marshall(a0.getPermissionsByRole(), a1)) + "}");
  }

  private void lazyInit() {

  }
}