package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_s_o_c_RepositoryConfiguration_1_Impl implements GeneratedMarshaller<RepositoryConfiguration> {
  private RepositoryConfiguration[] EMPTY_ARRAY = new RepositoryConfiguration[0];
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public RepositoryConfiguration[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RepositoryConfiguration demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RepositoryConfiguration.class, objId);
    }
    a1.setAssumedMapKeyType("java.lang.String");
    a1.setAssumedMapValueType("java.lang.Object");
    final Map c0 = java_util_Map.demarshall(obj.get("environment"), a1);
    a1.resetAssumedTypes();
    RepositoryConfiguration entity = new RepositoryConfiguration(c0);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(RepositoryConfiguration a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.organizationalunit.config.RepositoryConfiguration") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "environment") + "\":") + java_util_Map.marshall(a0.getEnvironment(), a1)) + "}");
  }

  private void lazyInit() {

  }
}