package org.jboss.errai.marshalling.client.api;

import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_s_o_c_RepositoryInfo_1_Impl implements GeneratedMarshaller<RepositoryInfo> {
  private RepositoryInfo[] EMPTY_ARRAY = new RepositoryInfo[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<RepositoryConfiguration> org_guvnor_structure_organizationalunit_config_RepositoryConfiguration = null;
  public RepositoryInfo[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RepositoryInfo demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RepositoryInfo.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    final Boolean c1 = java_lang_Boolean.demarshall(obj.get("deleted"), a1);
    final RepositoryConfiguration c2 = org_guvnor_structure_organizationalunit_config_RepositoryConfiguration.demarshall(obj.get("configuration"), a1);
    RepositoryInfo entity = new RepositoryInfo(c0, c1, c2);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(RepositoryInfo a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.organizationalunit.config.RepositoryInfo") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "deleted") + "\":") + java_lang_Boolean.marshall(a0.isDeleted(), a1)) + ",\"") + "configuration") + "\":") + org_guvnor_structure_organizationalunit_config_RepositoryConfiguration.marshall(a0.getConfiguration(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_structure_organizationalunit_config_RepositoryConfiguration == null) {
      org_guvnor_structure_organizationalunit_config_RepositoryConfiguration = Marshalling.getMarshaller(RepositoryConfiguration.class);
    }
  }
}