package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_s_o_c_RolePermissions_1_Impl implements GeneratedMarshaller<RolePermissions> {
  private RolePermissions[] EMPTY_ARRAY = new RolePermissions[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public RolePermissions[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RolePermissions demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RolePermissions.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("roleName"), a1);
    final Boolean c1 = java_lang_Boolean.demarshall(obj.get("canRead"), a1);
    final Boolean c2 = java_lang_Boolean.demarshall(obj.get("canWrite"), a1);
    final Boolean c3 = java_lang_Boolean.demarshall(obj.get("canDelete"), a1);
    final Boolean c4 = java_lang_Boolean.demarshall(obj.get("canDeploy"), a1);
    RolePermissions entity = new RolePermissions(c0, c1, c2, c3, c4);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "canRead": entity.setCanRead(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "canWrite": entity.setCanWrite(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "canDelete": entity.setCanDelete(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "canDeploy": entity.setCanDeploy(java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean RolePermissions_boolean_canRead(RolePermissions instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.config.RolePermissions::canRead;
  }-*/;

  native static void RolePermissions_boolean_canRead(RolePermissions instance, boolean value) /*-{
    instance.@org.guvnor.structure.organizationalunit.config.RolePermissions::canRead = value;
  }-*/;

  native static boolean RolePermissions_boolean_canWrite(RolePermissions instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.config.RolePermissions::canWrite;
  }-*/;

  native static void RolePermissions_boolean_canWrite(RolePermissions instance, boolean value) /*-{
    instance.@org.guvnor.structure.organizationalunit.config.RolePermissions::canWrite = value;
  }-*/;

  native static boolean RolePermissions_boolean_canDelete(RolePermissions instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.config.RolePermissions::canDelete;
  }-*/;

  native static void RolePermissions_boolean_canDelete(RolePermissions instance, boolean value) /*-{
    instance.@org.guvnor.structure.organizationalunit.config.RolePermissions::canDelete = value;
  }-*/;

  native static boolean RolePermissions_boolean_canDeploy(RolePermissions instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.config.RolePermissions::canDeploy;
  }-*/;

  native static void RolePermissions_boolean_canDeploy(RolePermissions instance, boolean value) /*-{
    instance.@org.guvnor.structure.organizationalunit.config.RolePermissions::canDeploy = value;
  }-*/;

  public String marshall(RolePermissions a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.organizationalunit.config.RolePermissions") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "roleName") + "\":") + java_lang_String.marshall(a0.getRoleName(), a1)) + ",\"") + "canRead") + "\":") + java_lang_Boolean.marshall(RolePermissions_boolean_canRead(a0), a1)) + ",\"") + "canWrite") + "\":") + java_lang_Boolean.marshall(RolePermissions_boolean_canWrite(a0), a1)) + ",\"") + "canDelete") + "\":") + java_lang_Boolean.marshall(RolePermissions_boolean_canDelete(a0), a1)) + ",\"") + "canDeploy") + "\":") + java_lang_Boolean.marshall(RolePermissions_boolean_canDeploy(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}