package org.jboss.errai.marshalling.client.api;

import java.util.Collection;
import java.util.List;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_g_s_o_c_SpaceInfo_1_Impl implements GeneratedMarshaller<SpaceInfo> {
  private SpaceInfo[] EMPTY_ARRAY = new SpaceInfo[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public SpaceInfo[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public SpaceInfo demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(SpaceInfo.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("defaultGroupId"), a1);
    final Collection c2 = (Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, obj.get("contributors"), a1);
    a1.setAssumedElementType("org.guvnor.structure.organizationalunit.config.RepositoryInfo");
    final List c3 = java_util_List.demarshall(obj.get("repositories"), a1);
    a1.setAssumedElementType("java.lang.String");
    final List c4 = java_util_List.demarshall(obj.get("securityGroups"), a1);
    SpaceInfo entity = new SpaceInfo(c0, c1, c2, c3, c4);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(SpaceInfo a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.organizationalunit.config.SpaceInfo") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "defaultGroupId") + "\":") + java_lang_String.marshall(a0.getDefaultGroupId(), a1)) + ",\"") + "contributors") + "\":") + java_lang_Object.marshall(a0.getContributors(), a1)) + ",\"") + "repositories") + "\":") + java_util_List.marshall(a0.getRepositories(), a1)) + ",\"") + "securityGroups") + "\":") + java_util_List.marshall(a0.getSecurityGroups(), a1)) + "}");
  }

  private void lazyInit() {

  }
}