package org.jboss.errai.marshalling.client.api;

import org.guvnor.structure.organizationalunit.config.SpaceState;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_s_o_c_SpaceState_1_Impl implements GeneratedMarshaller<SpaceState> {
  private SpaceState[] EMPTY_ARRAY = new SpaceState[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public SpaceState[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public SpaceState demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(SpaceState.class, objId);
    }
    final Boolean c0 = java_lang_Boolean.demarshall(obj.get("locked"), a1);
    SpaceState entity = new SpaceState(c0);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(SpaceState a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.organizationalunit.config.SpaceState") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "locked") + "\":") + java_lang_Boolean.marshall(a0.isLocked(), a1)) + "}");
  }

  private void lazyInit() {

  }
}