package org.jboss.errai.marshalling.client.api;

import java.util.Collection;
import java.util.Set;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_g_s_o_i_OrganizationalUnitImpl_1_Impl implements GeneratedMarshaller<OrganizationalUnitImpl> {
  private OrganizationalUnitImpl[] EMPTY_ARRAY = new OrganizationalUnitImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public OrganizationalUnitImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String OrganizationalUnitImpl_String_name(OrganizationalUnitImpl instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::name;
  }-*/;

  native static void OrganizationalUnitImpl_String_name(OrganizationalUnitImpl instance, String value) /*-{
    instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::name = value;
  }-*/;

  native static String OrganizationalUnitImpl_String_defaultGroupId(OrganizationalUnitImpl instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::defaultGroupId;
  }-*/;

  native static void OrganizationalUnitImpl_String_defaultGroupId(OrganizationalUnitImpl instance, String value) /*-{
    instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::defaultGroupId = value;
  }-*/;

  native static boolean OrganizationalUnitImpl_boolean_deleted(OrganizationalUnitImpl instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::deleted;
  }-*/;

  native static void OrganizationalUnitImpl_boolean_deleted(OrganizationalUnitImpl instance, boolean value) /*-{
    instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::deleted = value;
  }-*/;

  native static Collection OrganizationalUnitImpl_Collection_repositories(OrganizationalUnitImpl instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::repositories;
  }-*/;

  native static void OrganizationalUnitImpl_Collection_repositories(OrganizationalUnitImpl instance, Collection<Repository> value) /*-{
    instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::repositories = value;
  }-*/;

  native static Collection OrganizationalUnitImpl_Collection_groups(OrganizationalUnitImpl instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::groups;
  }-*/;

  native static void OrganizationalUnitImpl_Collection_groups(OrganizationalUnitImpl instance, Collection<String> value) /*-{
    instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::groups = value;
  }-*/;

  native static Collection OrganizationalUnitImpl_Collection_contributors(OrganizationalUnitImpl instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::contributors;
  }-*/;

  native static void OrganizationalUnitImpl_Collection_contributors(OrganizationalUnitImpl instance, Collection<Contributor> value) /*-{
    instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::contributors = value;
  }-*/;

  native static boolean OrganizationalUnitImpl_boolean_requiresRefresh(OrganizationalUnitImpl instance) /*-{
    return instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::requiresRefresh;
  }-*/;

  native static void OrganizationalUnitImpl_boolean_requiresRefresh(OrganizationalUnitImpl instance, boolean value) /*-{
    instance.@org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl::requiresRefresh = value;
  }-*/;

  public OrganizationalUnitImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(OrganizationalUnitImpl.class, objId);
    }
    OrganizationalUnitImpl entity = new OrganizationalUnitImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": OrganizationalUnitImpl_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "defaultGroupId": OrganizationalUnitImpl_String_defaultGroupId(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "deleted": OrganizationalUnitImpl_boolean_deleted(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "repositories": OrganizationalUnitImpl_Collection_repositories(entity, (Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "groups": OrganizationalUnitImpl_Collection_groups(entity, (Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "contributors": OrganizationalUnitImpl_Collection_contributors(entity, (Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "requiresRefresh": OrganizationalUnitImpl_boolean_requiresRefresh(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(OrganizationalUnitImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "defaultGroupId") + "\":") + java_lang_String.marshall(a0.getDefaultGroupId(), a1)) + ",\"") + "deleted") + "\":") + java_lang_Boolean.marshall(OrganizationalUnitImpl_boolean_deleted(a0), a1)) + ",\"") + "repositories") + "\":") + java_lang_Object.marshall(a0.getRepositories(), a1)) + ",\"") + "groups") + "\":") + java_lang_Object.marshall(a0.getGroups(), a1)) + ",\"") + "contributors") + "\":") + java_lang_Object.marshall(a0.getContributors(), a1)) + ",\"") + "requiresRefresh") + "\":") + java_lang_Boolean.marshall(OrganizationalUnitImpl_boolean_requiresRefresh(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}