package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.structure.repositories.Branch;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_g_s_r_Branch_1_Impl implements GeneratedMarshaller<Branch> {
  private Branch[] EMPTY_ARRAY = new Branch[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public Branch[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String Branch_String_name(Branch instance) /*-{
    return instance.@org.guvnor.structure.repositories.Branch::name;
  }-*/;

  native static void Branch_String_name(Branch instance, String value) /*-{
    instance.@org.guvnor.structure.repositories.Branch::name = value;
  }-*/;

  native static Path Branch_Path_path(Branch instance) /*-{
    return instance.@org.guvnor.structure.repositories.Branch::path;
  }-*/;

  native static void Branch_Path_path(Branch instance, Path value) /*-{
    instance.@org.guvnor.structure.repositories.Branch::path = value;
  }-*/;

  public Branch demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Branch.class, objId);
    }
    Branch entity = new Branch();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": Branch_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "path": Branch_Path_path(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Branch a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.repositories.Branch") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + "}");
  }

  private void lazyInit() {

  }
}