package org.jboss.errai.marshalling.client.api;

import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.jboss.errai.security.shared.api.identity.User;

public class Marshaller_o_g_s_r_NewBranchEvent_1_Impl implements GeneratedMarshaller<NewBranchEvent> {
  private NewBranchEvent[] EMPTY_ARRAY = new NewBranchEvent[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public NewBranchEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public NewBranchEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NewBranchEvent.class, objId);
    }
    final Repository c0 = (Repository) ((ObjectMarshaller) java_lang_Object).demarshall(Repository.class, obj.get("repository"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("newBranchName"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("fromBranchName"), a1);
    final User c3 = (User) ((ObjectMarshaller) java_lang_Object).demarshall(User.class, obj.get("user"), a1);
    NewBranchEvent entity = new NewBranchEvent(c0, c1, c2, c3);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(NewBranchEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.repositories.NewBranchEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "repository") + "\":") + java_lang_Object.marshall(a0.getRepository(), a1)) + ",\"") + "newBranchName") + "\":") + java_lang_String.marshall(a0.getNewBranchName(), a1)) + ",\"") + "fromBranchName") + "\":") + java_lang_String.marshall(a0.getFromBranchName(), a1)) + ",\"") + "user") + "\":") + java_lang_Object.marshall(a0.getUser(), a1)) + "}");
  }

  private void lazyInit() {

  }
}