package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_g_s_r_RepositoryEnvironmentConfiguration_1_Impl implements GeneratedMarshaller<RepositoryEnvironmentConfiguration> {
  private RepositoryEnvironmentConfiguration[] EMPTY_ARRAY = new RepositoryEnvironmentConfiguration[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public RepositoryEnvironmentConfiguration[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String RepositoryEnvironmentConfiguration_String_name(RepositoryEnvironmentConfiguration instance) /*-{
    return instance.@org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration::name;
  }-*/;

  native static void RepositoryEnvironmentConfiguration_String_name(RepositoryEnvironmentConfiguration instance, String value) /*-{
    instance.@org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration::name = value;
  }-*/;

  native static Object RepositoryEnvironmentConfiguration_Object_value(RepositoryEnvironmentConfiguration instance) /*-{
    return instance.@org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration::value;
  }-*/;

  native static void RepositoryEnvironmentConfiguration_Object_value(RepositoryEnvironmentConfiguration instance, Object value) /*-{
    instance.@org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration::value = value;
  }-*/;

  public RepositoryEnvironmentConfiguration demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RepositoryEnvironmentConfiguration.class, objId);
    }
    RepositoryEnvironmentConfiguration entity = new RepositoryEnvironmentConfiguration();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": RepositoryEnvironmentConfiguration_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "value": RepositoryEnvironmentConfiguration_Object_value(entity, ((ObjectMarshaller) java_lang_Object).demarshall(Object.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(RepositoryEnvironmentConfiguration a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "value") + "\":") + java_lang_Object.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}