package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentUpdatedEvent;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_g_s_r_RepositoryEnvironmentUpdatedEvent_1_Impl implements GeneratedMarshaller<RepositoryEnvironmentUpdatedEvent> {
  private RepositoryEnvironmentUpdatedEvent[] EMPTY_ARRAY = new RepositoryEnvironmentUpdatedEvent[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public RepositoryEnvironmentUpdatedEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RepositoryEnvironmentUpdatedEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RepositoryEnvironmentUpdatedEvent.class, objId);
    }
    RepositoryEnvironmentUpdatedEvent entity = new RepositoryEnvironmentUpdatedEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "updatedRepository": entity.setUpdatedRepository((Repository) ((ObjectMarshaller) java_lang_Object).demarshall(Repository.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(RepositoryEnvironmentUpdatedEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.repositories.RepositoryEnvironmentUpdatedEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "updatedRepository") + "\":") + java_lang_Object.marshall(a0.getUpdatedRepository(), a1)) + "}");
  }

  private void lazyInit() {

  }
}