package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.backend.vfs.Path;
import org.uberfire.java.nio.base.version.VersionRecord;

public class Marshaller_o_g_s_r_RepositoryInfo_1_Impl implements GeneratedMarshaller<RepositoryInfo> {
  private RepositoryInfo[] EMPTY_ARRAY = new RepositoryInfo[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public RepositoryInfo[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String RepositoryInfo_String_id(RepositoryInfo instance) /*-{
    return instance.@org.guvnor.structure.repositories.RepositoryInfo::id;
  }-*/;

  native static void RepositoryInfo_String_id(RepositoryInfo instance, String value) /*-{
    instance.@org.guvnor.structure.repositories.RepositoryInfo::id = value;
  }-*/;

  native static String RepositoryInfo_String_alias(RepositoryInfo instance) /*-{
    return instance.@org.guvnor.structure.repositories.RepositoryInfo::alias;
  }-*/;

  native static void RepositoryInfo_String_alias(RepositoryInfo instance, String value) /*-{
    instance.@org.guvnor.structure.repositories.RepositoryInfo::alias = value;
  }-*/;

  native static String RepositoryInfo_String_owner(RepositoryInfo instance) /*-{
    return instance.@org.guvnor.structure.repositories.RepositoryInfo::owner;
  }-*/;

  native static void RepositoryInfo_String_owner(RepositoryInfo instance, String value) /*-{
    instance.@org.guvnor.structure.repositories.RepositoryInfo::owner = value;
  }-*/;

  native static Path RepositoryInfo_Path_root(RepositoryInfo instance) /*-{
    return instance.@org.guvnor.structure.repositories.RepositoryInfo::root;
  }-*/;

  native static void RepositoryInfo_Path_root(RepositoryInfo instance, Path value) /*-{
    instance.@org.guvnor.structure.repositories.RepositoryInfo::root = value;
  }-*/;

  native static List RepositoryInfo_List_publicURIs(RepositoryInfo instance) /*-{
    return instance.@org.guvnor.structure.repositories.RepositoryInfo::publicURIs;
  }-*/;

  native static void RepositoryInfo_List_publicURIs(RepositoryInfo instance, List<PublicURI> value) /*-{
    instance.@org.guvnor.structure.repositories.RepositoryInfo::publicURIs = value;
  }-*/;

  native static List RepositoryInfo_List_versionList(RepositoryInfo instance) /*-{
    return instance.@org.guvnor.structure.repositories.RepositoryInfo::versionList;
  }-*/;

  native static void RepositoryInfo_List_versionList(RepositoryInfo instance, List<VersionRecord> value) /*-{
    instance.@org.guvnor.structure.repositories.RepositoryInfo::versionList = value;
  }-*/;

  public RepositoryInfo demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RepositoryInfo.class, objId);
    }
    RepositoryInfo entity = new RepositoryInfo();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "id": RepositoryInfo_String_id(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "alias": RepositoryInfo_String_alias(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "owner": RepositoryInfo_String_owner(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "root": RepositoryInfo_Path_root(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "publicURIs": a1.setAssumedElementType("org.guvnor.structure.repositories.PublicURI");
        RepositoryInfo_List_publicURIs(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "versionList": a1.setAssumedElementType("org.uberfire.java.nio.base.version.VersionRecord");
        RepositoryInfo_List_versionList(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(RepositoryInfo a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.repositories.RepositoryInfo") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "alias") + "\":") + java_lang_String.marshall(a0.getAlias(), a1)) + ",\"") + "owner") + "\":") + java_lang_String.marshall(a0.getOwner(), a1)) + ",\"") + "root") + "\":") + java_lang_Object.marshall(a0.getRoot(), a1)) + ",\"") + "publicURIs") + "\":") + java_util_List.marshall(a0.getPublicURIs(), a1)) + ",\"") + "versionList") + "\":") + java_util_List.marshall(RepositoryInfo_List_versionList(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}