package org.jboss.errai.marshalling.client.api;

import java.util.List;
import org.guvnor.structure.repositories.changerequest.portable.PaginatedChangeRequestList;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_s_r_c_p_PaginatedChangeRequestList_1_Impl implements GeneratedMarshaller<PaginatedChangeRequestList> {
  private PaginatedChangeRequestList[] EMPTY_ARRAY = new PaginatedChangeRequestList[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public PaginatedChangeRequestList[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PaginatedChangeRequestList demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PaginatedChangeRequestList.class, objId);
    }
    a1.setAssumedElementType("org.guvnor.structure.repositories.changerequest.portable.ChangeRequest");
    final List c0 = java_util_List.demarshall(obj.get("changeRequests"), a1);
    final Integer c1 = java_lang_Integer.demarshall(obj.get("pageNumber"), a1);
    final Integer c2 = java_lang_Integer.demarshall(obj.get("pageSize"), a1);
    final Integer c3 = java_lang_Integer.demarshall(obj.get("total"), a1);
    PaginatedChangeRequestList entity = new PaginatedChangeRequestList(c0, c1, c2, c3);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(PaginatedChangeRequestList a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.repositories.changerequest.portable.PaginatedChangeRequestList") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "changeRequests") + "\":") + java_util_List.marshall(a0.getChangeRequests(), a1)) + ",\"") + "pageNumber") + "\":") + java_lang_Integer.marshall(a0.getPageNumber(), a1)) + ",\"") + "pageSize") + "\":") + java_lang_Integer.marshall(a0.getPageSize(), a1)) + ",\"") + "total") + "\":") + java_lang_Integer.marshall(a0.getTotal(), a1)) + "}");
  }

  private void lazyInit() {

  }
}