package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.structure.repositories.impl.DefaultPublicURI;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_s_r_i_DefaultPublicURI_1_Impl implements GeneratedMarshaller<DefaultPublicURI> {
  private DefaultPublicURI[] EMPTY_ARRAY = new DefaultPublicURI[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public DefaultPublicURI[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DefaultPublicURI demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DefaultPublicURI.class, objId);
    }
    DefaultPublicURI entity = new DefaultPublicURI();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "protocol": entity.setProtocol(java_lang_String.demarshall(objVal, a1));
        break;
        case "uri": entity.setURI(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DefaultPublicURI a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.repositories.impl.DefaultPublicURI") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "protocol") + "\":") + java_lang_String.marshall(a0.getProtocol(), a1)) + ",\"") + "uri") + "\":") + java_lang_String.marshall(a0.getURI(), a1)) + "}");
  }

  private void lazyInit() {

  }
}