package org.jboss.errai.marshalling.client.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.spaces.Space;

public class Marshaller_o_g_s_r_i_g_GitRepository_1_Impl implements GeneratedMarshaller<GitRepository> {
  private GitRepository[] EMPTY_ARRAY = new GitRepository[0];
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Space> org_uberfire_spaces_Space = null;
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public GitRepository[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Map GitRepository_Map_environment(GitRepository instance) /*-{
    return instance.@org.guvnor.structure.repositories.impl.git.GitRepository::environment;
  }-*/;

  native static void GitRepository_Map_environment(GitRepository instance, Map value) /*-{
    instance.@org.guvnor.structure.repositories.impl.git.GitRepository::environment = value;
  }-*/;

  native static String GitRepository_String_alias(GitRepository instance) /*-{
    return instance.@org.guvnor.structure.repositories.impl.git.GitRepository::alias;
  }-*/;

  native static void GitRepository_String_alias(GitRepository instance, String value) /*-{
    instance.@org.guvnor.structure.repositories.impl.git.GitRepository::alias = value;
  }-*/;

  native static Space GitRepository_Space_space(GitRepository instance) /*-{
    return instance.@org.guvnor.structure.repositories.impl.git.GitRepository::space;
  }-*/;

  native static void GitRepository_Space_space(GitRepository instance, Space value) /*-{
    instance.@org.guvnor.structure.repositories.impl.git.GitRepository::space = value;
  }-*/;

  native static Collection GitRepository_Collection_contributors(GitRepository instance) /*-{
    return instance.@org.guvnor.structure.repositories.impl.git.GitRepository::contributors;
  }-*/;

  native static void GitRepository_Collection_contributors(GitRepository instance, Collection<Contributor> value) /*-{
    instance.@org.guvnor.structure.repositories.impl.git.GitRepository::contributors = value;
  }-*/;

  native static boolean GitRepository_boolean_requiresRefresh(GitRepository instance) /*-{
    return instance.@org.guvnor.structure.repositories.impl.git.GitRepository::requiresRefresh;
  }-*/;

  native static void GitRepository_boolean_requiresRefresh(GitRepository instance, boolean value) /*-{
    instance.@org.guvnor.structure.repositories.impl.git.GitRepository::requiresRefresh = value;
  }-*/;

  native static boolean GitRepository_boolean_deleted(GitRepository instance) /*-{
    return instance.@org.guvnor.structure.repositories.impl.git.GitRepository::deleted;
  }-*/;

  native static void GitRepository_boolean_deleted(GitRepository instance, boolean value) /*-{
    instance.@org.guvnor.structure.repositories.impl.git.GitRepository::deleted = value;
  }-*/;

  public GitRepository demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(GitRepository.class, objId);
    }
    GitRepository entity = new GitRepository();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "environment": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.Object");
        GitRepository_Map_environment(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "publicURIs": a1.setAssumedElementType("org.guvnor.structure.repositories.PublicURI");
        entity.setPublicURIs(java_util_List.demarshall(objVal, a1));
        break;
        case "branches": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.guvnor.structure.repositories.Branch");
        entity.setBranches(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "alias": GitRepository_String_alias(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "space": GitRepository_Space_space(entity, org_uberfire_spaces_Space.demarshall(objVal, a1));
        break;
        case "groups": entity.setGroups((Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "contributors": GitRepository_Collection_contributors(entity, (Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "requiresRefresh": GitRepository_boolean_requiresRefresh(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "deleted": GitRepository_boolean_deleted(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static Map GitRepository_Map_branches(GitRepository instance) /*-{
    return instance.@org.guvnor.structure.repositories.impl.git.GitRepository::branches;
  }-*/;

  native static void GitRepository_Map_branches(GitRepository instance, Map<String, Branch> value) /*-{
    instance.@org.guvnor.structure.repositories.impl.git.GitRepository::branches = value;
  }-*/;

  public String marshall(GitRepository a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.structure.repositories.impl.git.GitRepository") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((("" + ",\"") + "environment") + "\":") + java_util_Map.marshall(a0.getEnvironment(), a1)) + ",\"") + "publicURIs") + "\":") + java_util_List.marshall(a0.getPublicURIs(), a1)) + ",\"") + "branches") + "\":") + java_util_Map.marshall(GitRepository_Map_branches(a0), a1)) + ",\"") + "alias") + "\":") + java_lang_String.marshall(a0.getAlias(), a1)) + ",\"") + "space") + "\":") + org_uberfire_spaces_Space.marshall(a0.getSpace(), a1)) + ",\"") + "groups") + "\":") + java_lang_Object.marshall(a0.getGroups(), a1)) + ",\"") + "contributors") + "\":") + java_lang_Object.marshall(a0.getContributors(), a1)) + ",\"") + "requiresRefresh") + "\":") + java_lang_Boolean.marshall(GitRepository_boolean_requiresRefresh(a0), a1)) + ",\"") + "deleted") + "\":") + java_lang_Boolean.marshall(GitRepository_boolean_deleted(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (org_uberfire_spaces_Space == null) {
      org_uberfire_spaces_Space = Marshalling.getMarshaller(Space.class);
    }
  }
}