package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.es.model.ErrorSummary;

public class Marshaller_o_j_w_e_m_ErrorSummary_1_Impl implements GeneratedMarshaller<ErrorSummary> {
  private ErrorSummary[] EMPTY_ARRAY = new ErrorSummary[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ErrorSummary[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ErrorSummary demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ErrorSummary.class, objId);
    }
    ErrorSummary entity = new ErrorSummary();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "id": entity.setId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "time": entity.setTime(java_util_Date.demarshall(objVal, a1));
        break;
        case "message": entity.setMessage(java_lang_String.demarshall(objVal, a1));
        break;
        case "stacktrace": entity.setStacktrace(java_lang_String.demarshall(objVal, a1));
        break;
        case "requestInfoId": entity.setRequestInfoId(java_lang_Long.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ErrorSummary a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.es.model.ErrorSummary") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "id") + "\":") + java_lang_Long.marshall(a0.getId(), a1)) + ",\"") + "time") + "\":") + java_util_Date.marshall(a0.getTime(), a1)) + ",\"") + "message") + "\":") + java_lang_String.marshall(a0.getMessage(), a1)) + ",\"") + "stacktrace") + "\":") + java_lang_String.marshall(a0.getStacktrace(), a1)) + ",\"") + "requestInfoId") + "\":") + java_lang_Long.marshall(a0.getRequestInfoId(), a1)) + "}");
  }

  private void lazyInit() {

  }
}