package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.es.model.RequestDetails;
import org.jbpm.workbench.es.model.RequestSummary;

public class Marshaller_o_j_w_e_m_RequestDetails_1_Impl implements GeneratedMarshaller<RequestDetails> {
  private RequestDetails[] EMPTY_ARRAY = new RequestDetails[0];
  private Marshaller<RequestSummary> org_jbpm_workbench_es_model_RequestSummary = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public RequestDetails[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RequestDetails demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RequestDetails.class, objId);
    }
    RequestDetails entity = new RequestDetails();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "request": entity.setRequest(org_jbpm_workbench_es_model_RequestSummary.demarshall(objVal, a1));
        break;
        case "errors": a1.setAssumedElementType("org.jbpm.workbench.es.model.ErrorSummary");
        entity.setErrors(java_util_List.demarshall(objVal, a1));
        break;
        case "params": a1.setAssumedElementType("org.jbpm.workbench.es.model.RequestParameterSummary");
        entity.setParams(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(RequestDetails a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.es.model.RequestDetails") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "request") + "\":") + org_jbpm_workbench_es_model_RequestSummary.marshall(a0.getRequest(), a1)) + ",\"") + "errors") + "\":") + java_util_List.marshall(a0.getErrors(), a1)) + ",\"") + "params") + "\":") + java_util_List.marshall(a0.getParams(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_jbpm_workbench_es_model_RequestSummary == null) {
      org_jbpm_workbench_es_model_RequestSummary = Marshalling.getMarshaller(RequestSummary.class);
    }
  }
}