package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;

public class Marshaller_o_j_w_e_m_e_RequestChangedEvent_1_Impl implements GeneratedMarshaller<RequestChangedEvent> {
  private RequestChangedEvent[] EMPTY_ARRAY = new RequestChangedEvent[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public RequestChangedEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RequestChangedEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RequestChangedEvent.class, objId);
    }
    RequestChangedEvent entity = new RequestChangedEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "requestId": entity.setRequestId(java_lang_Long.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(RequestChangedEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.es.model.events.RequestChangedEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "requestId") + "\":") + java_lang_Long.marshall(a0.getRequestId(), a1)) + "}");
  }

  private void lazyInit() {

  }
}