package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.ht.model.TaskSummary;

public class Marshaller_o_j_w_h_m_TaskSummary_1_Impl implements GeneratedMarshaller<TaskSummary> {
  private TaskSummary[] EMPTY_ARRAY = new TaskSummary[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public TaskSummary[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Boolean TaskSummary_Boolean_isForAdmin(TaskSummary instance) /*-{
    return instance.@org.jbpm.workbench.ht.model.TaskSummary::isForAdmin;
  }-*/;

  native static void TaskSummary_Boolean_isForAdmin(TaskSummary instance, Boolean value) /*-{
    instance.@org.jbpm.workbench.ht.model.TaskSummary::isForAdmin = value;
  }-*/;

  native static Boolean TaskSummary_Boolean_isLogOnly(TaskSummary instance) /*-{
    return instance.@org.jbpm.workbench.ht.model.TaskSummary::isLogOnly;
  }-*/;

  native static void TaskSummary_Boolean_isLogOnly(TaskSummary instance, Boolean value) /*-{
    instance.@org.jbpm.workbench.ht.model.TaskSummary::isLogOnly = value;
  }-*/;

  public TaskSummary demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TaskSummary.class, objId);
    }
    TaskSummary entity = new TaskSummary();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "status": entity.setStatus(java_lang_String.demarshall(objVal, a1));
        break;
        case "priority": entity.setPriority(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "actualOwner": entity.setActualOwner(java_lang_String.demarshall(objVal, a1));
        break;
        case "createdBy": entity.setCreatedBy(java_lang_String.demarshall(objVal, a1));
        break;
        case "createdOn": entity.setCreatedOn(java_util_Date.demarshall(objVal, a1));
        break;
        case "activationTime": entity.setActivationTime(java_util_Date.demarshall(objVal, a1));
        break;
        case "expirationTime": entity.setExpirationTime(java_util_Date.demarshall(objVal, a1));
        break;
        case "lastModificationDate": entity.setLastModificationDate(java_util_Date.demarshall(objVal, a1));
        break;
        case "processInstanceId": entity.setProcessInstanceId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "processInstanceCorrelationKey": entity.setProcessInstanceCorrelationKey(java_lang_String.demarshall(objVal, a1));
        break;
        case "processInstanceDescription": entity.setProcessInstanceDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "processId": entity.setProcessId(java_lang_String.demarshall(objVal, a1));
        break;
        case "processSessionId": entity.setProcessSessionId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "deploymentId": entity.setDeploymentId(java_lang_String.demarshall(objVal, a1));
        break;
        case "isForAdmin": TaskSummary_Boolean_isForAdmin(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "isLogOnly": TaskSummary_Boolean_isLogOnly(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "parentId": entity.setParentId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "slaCompliance": entity.setSlaCompliance(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "slaDueDate": entity.setSlaDueDate(java_util_Date.demarshall(objVal, a1));
        break;
        case "workItemId": entity.setWorkItemId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "domainData": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setDomainData(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "errorCount": entity.setErrorCount(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "id": entity.setId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(TaskSummary a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.ht.model.TaskSummary") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "status") + "\":") + java_lang_String.marshall(a0.getStatus(), a1)) + ",\"") + "priority") + "\":") + java_lang_Integer.marshall(a0.getPriority(), a1)) + ",\"") + "actualOwner") + "\":") + java_lang_String.marshall(a0.getActualOwner(), a1)) + ",\"") + "createdBy") + "\":") + java_lang_String.marshall(a0.getCreatedBy(), a1)) + ",\"") + "createdOn") + "\":") + java_util_Date.marshall(a0.getCreatedOn(), a1)) + ",\"") + "activationTime") + "\":") + java_util_Date.marshall(a0.getActivationTime(), a1)) + ",\"") + "expirationTime") + "\":") + java_util_Date.marshall(a0.getExpirationTime(), a1)) + ",\"") + "lastModificationDate") + "\":") + java_util_Date.marshall(a0.getLastModificationDate(), a1)) + ",\"") + "processInstanceId") + "\":") + java_lang_Long.marshall(a0.getProcessInstanceId(), a1)) + ",\"") + "processInstanceCorrelationKey") + "\":") + java_lang_String.marshall(a0.getProcessInstanceCorrelationKey(), a1)) + ",\"") + "processInstanceDescription") + "\":") + java_lang_String.marshall(a0.getProcessInstanceDescription(), a1)) + ",\"") + "processId") + "\":") + java_lang_String.marshall(a0.getProcessId(), a1)) + ",\"") + "processSessionId") + "\":") + java_lang_Long.marshall(a0.getProcessSessionId(), a1)) + ",\"") + "deploymentId") + "\":") + java_lang_String.marshall(a0.getDeploymentId(), a1)) + ",\"") + "isForAdmin") + "\":") + java_lang_Boolean.marshall(TaskSummary_Boolean_isForAdmin(a0), a1)) + ",\"") + "isLogOnly") + "\":") + java_lang_Boolean.marshall(TaskSummary_Boolean_isLogOnly(a0), a1)) + ",\"") + "parentId") + "\":") + java_lang_Long.marshall(a0.getParentId(), a1)) + ",\"") + "slaCompliance") + "\":") + java_lang_Integer.marshall(a0.getSlaCompliance(), a1)) + ",\"") + "slaDueDate") + "\":") + java_util_Date.marshall(a0.getSlaDueDate(), a1)) + ",\"") + "workItemId") + "\":") + java_lang_Long.marshall(a0.getWorkItemId(), a1)) + ",\"") + "domainData") + "\":") + java_util_Map.marshall(a0.getDomainData(), a1)) + ",\"") + "errorCount") + "\":") + java_lang_Integer.marshall(a0.getErrorCount(), a1)) + ",\"") + "id") + "\":") + java_lang_Long.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}