package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;

public class Marshaller_o_j_w_h_m_e_TaskCompletedEvent_1_Impl implements GeneratedMarshaller<TaskCompletedEvent> {
  private TaskCompletedEvent[] EMPTY_ARRAY = new TaskCompletedEvent[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public TaskCompletedEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public TaskCompletedEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TaskCompletedEvent.class, objId);
    }
    TaskCompletedEvent entity = new TaskCompletedEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "serverTemplateId": entity.setServerTemplateId(java_lang_String.demarshall(objVal, a1));
        break;
        case "containerId": entity.setContainerId(java_lang_String.demarshall(objVal, a1));
        break;
        case "taskId": entity.setTaskId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "taskName": entity.setTaskName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(TaskCompletedEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.ht.model.events.TaskCompletedEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "serverTemplateId") + "\":") + java_lang_String.marshall(a0.getServerTemplateId(), a1)) + ",\"") + "containerId") + "\":") + java_lang_String.marshall(a0.getContainerId(), a1)) + ",\"") + "taskId") + "\":") + java_lang_Long.marshall(a0.getTaskId(), a1)) + ",\"") + "taskName") + "\":") + java_lang_String.marshall(a0.getTaskName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}