package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;

public class Marshaller_o_j_w_p_e_ProcessDefSelectionEvent_1_Impl implements GeneratedMarshaller<ProcessDefSelectionEvent> {
  private ProcessDefSelectionEvent[] EMPTY_ARRAY = new ProcessDefSelectionEvent[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public ProcessDefSelectionEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ProcessDefSelectionEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProcessDefSelectionEvent.class, objId);
    }
    ProcessDefSelectionEvent entity = new ProcessDefSelectionEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "processId": entity.setProcessId(java_lang_String.demarshall(objVal, a1));
        break;
        case "processDefName": entity.setProcessDefName(java_lang_String.demarshall(objVal, a1));
        break;
        case "deploymentId": entity.setDeploymentId(java_lang_String.demarshall(objVal, a1));
        break;
        case "serverTemplateId": entity.setServerTemplateId(java_lang_String.demarshall(objVal, a1));
        break;
        case "dynamic": entity.setDynamic(java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean ProcessDefSelectionEvent_boolean_dynamic(ProcessDefSelectionEvent instance) /*-{
    return instance.@org.jbpm.workbench.pr.events.ProcessDefSelectionEvent::dynamic;
  }-*/;

  native static void ProcessDefSelectionEvent_boolean_dynamic(ProcessDefSelectionEvent instance, boolean value) /*-{
    instance.@org.jbpm.workbench.pr.events.ProcessDefSelectionEvent::dynamic = value;
  }-*/;

  public String marshall(ProcessDefSelectionEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.pr.events.ProcessDefSelectionEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "processId") + "\":") + java_lang_String.marshall(a0.getProcessId(), a1)) + ",\"") + "processDefName") + "\":") + java_lang_String.marshall(a0.getProcessDefName(), a1)) + ",\"") + "deploymentId") + "\":") + java_lang_String.marshall(a0.getDeploymentId(), a1)) + ",\"") + "serverTemplateId") + "\":") + java_lang_String.marshall(a0.getServerTemplateId(), a1)) + ",\"") + "dynamic") + "\":") + java_lang_Boolean.marshall(ProcessDefSelectionEvent_boolean_dynamic(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}