package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;

public class Marshaller_o_j_w_p_e_ProcessInstancesUpdateEvent_1_Impl implements GeneratedMarshaller<ProcessInstancesUpdateEvent> {
  private ProcessInstancesUpdateEvent[] EMPTY_ARRAY = new ProcessInstancesUpdateEvent[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public ProcessInstancesUpdateEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ProcessInstancesUpdateEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProcessInstancesUpdateEvent.class, objId);
    }
    ProcessInstancesUpdateEvent entity = new ProcessInstancesUpdateEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "processInstanceId": entity.setProcessInstanceId(java_lang_Long.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ProcessInstancesUpdateEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "processInstanceId") + "\":") + java_lang_Long.marshall(a0.getProcessInstanceId(), a1)) + "}");
  }

  private void lazyInit() {

  }
}