package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;

public class Marshaller_o_j_w_p_m_NodeInstanceSummary_1_Impl implements GeneratedMarshaller<NodeInstanceSummary> {
  private NodeInstanceSummary[] EMPTY_ARRAY = new NodeInstanceSummary[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public NodeInstanceSummary[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public NodeInstanceSummary demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NodeInstanceSummary.class, objId);
    }
    NodeInstanceSummary entity = new NodeInstanceSummary();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "processId": entity.setProcessId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "nodeUniqueName": entity.setNodeUniqueName(java_lang_String.demarshall(objVal, a1));
        break;
        case "type": entity.setType(java_lang_String.demarshall(objVal, a1));
        break;
        case "timestamp": entity.setTimestamp(java_util_Date.demarshall(objVal, a1));
        break;
        case "connection": entity.setConnection(java_lang_String.demarshall(objVal, a1));
        break;
        case "completed": entity.setCompleted(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "referenceId": entity.setReferenceId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "slaCompliance": entity.setSlaCompliance(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "slaDueDate": entity.setSlaDueDate(java_util_Date.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "id": entity.setId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static Boolean NodeInstanceSummary_Boolean_completed(NodeInstanceSummary instance) /*-{
    return instance.@org.jbpm.workbench.pr.model.NodeInstanceSummary::completed;
  }-*/;

  native static void NodeInstanceSummary_Boolean_completed(NodeInstanceSummary instance, Boolean value) /*-{
    instance.@org.jbpm.workbench.pr.model.NodeInstanceSummary::completed = value;
  }-*/;

  public String marshall(NodeInstanceSummary a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.pr.model.NodeInstanceSummary") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "processId") + "\":") + java_lang_Long.marshall(a0.getProcessId(), a1)) + ",\"") + "nodeUniqueName") + "\":") + java_lang_String.marshall(a0.getNodeUniqueName(), a1)) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "timestamp") + "\":") + java_util_Date.marshall(a0.getTimestamp(), a1)) + ",\"") + "connection") + "\":") + java_lang_String.marshall(a0.getConnection(), a1)) + ",\"") + "completed") + "\":") + java_lang_Boolean.marshall(NodeInstanceSummary_Boolean_completed(a0), a1)) + ",\"") + "referenceId") + "\":") + java_lang_Long.marshall(a0.getReferenceId(), a1)) + ",\"") + "slaCompliance") + "\":") + java_lang_Integer.marshall(a0.getSlaCompliance(), a1)) + ",\"") + "slaDueDate") + "\":") + java_util_Date.marshall(a0.getSlaDueDate(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "id") + "\":") + java_lang_Long.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}