package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;

public class Marshaller_o_j_w_p_m_ProcessInstanceLogSummary_1_Impl implements GeneratedMarshaller<ProcessInstanceLogSummary> {
  private ProcessInstanceLogSummary[] EMPTY_ARRAY = new ProcessInstanceLogSummary[0];
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public ProcessInstanceLogSummary[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ProcessInstanceLogSummary demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProcessInstanceLogSummary.class, objId);
    }
    ProcessInstanceLogSummary entity = new ProcessInstanceLogSummary();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "date": entity.setDate(java_util_Date.demarshall(objVal, a1));
        break;
        case "nodeId": entity.setNodeId(java_lang_String.demarshall(objVal, a1));
        break;
        case "nodeType": entity.setNodeType(java_lang_String.demarshall(objVal, a1));
        break;
        case "completed": entity.setCompleted(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "workItemId": entity.setWorkItemId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "referenceId": entity.setReferenceId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "nodeContainerId": entity.setNodeContainerId(java_lang_String.demarshall(objVal, a1));
        break;
        case "logType": entity.setLogType(java_lang_Long.demarshall(objVal, a1));
        break;
        case "logDeploymentId": entity.setLogDeploymentId(java_lang_String.demarshall(objVal, a1));
        break;
        case "id": entity.setId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean ProcessInstanceLogSummary_boolean_completed(ProcessInstanceLogSummary instance) /*-{
    return instance.@org.jbpm.workbench.pr.model.ProcessInstanceLogSummary::completed;
  }-*/;

  native static void ProcessInstanceLogSummary_boolean_completed(ProcessInstanceLogSummary instance, boolean value) /*-{
    instance.@org.jbpm.workbench.pr.model.ProcessInstanceLogSummary::completed = value;
  }-*/;

  public String marshall(ProcessInstanceLogSummary a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.pr.model.ProcessInstanceLogSummary") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "date") + "\":") + java_util_Date.marshall(a0.getDate(), a1)) + ",\"") + "nodeId") + "\":") + java_lang_String.marshall(a0.getNodeId(), a1)) + ",\"") + "nodeType") + "\":") + java_lang_String.marshall(a0.getNodeType(), a1)) + ",\"") + "completed") + "\":") + java_lang_Boolean.marshall(ProcessInstanceLogSummary_boolean_completed(a0), a1)) + ",\"") + "workItemId") + "\":") + java_lang_Long.marshall(a0.getWorkItemId(), a1)) + ",\"") + "referenceId") + "\":") + java_lang_Long.marshall(a0.getReferenceId(), a1)) + ",\"") + "nodeContainerId") + "\":") + java_lang_String.marshall(a0.getNodeContainerId(), a1)) + ",\"") + "logType") + "\":") + java_lang_Long.marshall(a0.getLogType(), a1)) + ",\"") + "logDeploymentId") + "\":") + java_lang_String.marshall(a0.getLogDeploymentId(), a1)) + ",\"") + "id") + "\":") + java_lang_Long.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}