package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;

public class Marshaller_o_j_w_p_m_ProcessVariableSummary_1_Impl implements GeneratedMarshaller<ProcessVariableSummary> {
  private ProcessVariableSummary[] EMPTY_ARRAY = new ProcessVariableSummary[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public ProcessVariableSummary[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ProcessVariableSummary demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProcessVariableSummary.class, objId);
    }
    ProcessVariableSummary entity = new ProcessVariableSummary();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "variableId": entity.setVariableId(java_lang_String.demarshall(objVal, a1));
        break;
        case "variableInstanceId": entity.setVariableInstanceId(java_lang_String.demarshall(objVal, a1));
        break;
        case "processInstanceId": entity.setProcessInstanceId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "oldValue": entity.setOldValue(java_lang_String.demarshall(objVal, a1));
        break;
        case "newValue": entity.setNewValue(java_lang_String.demarshall(objVal, a1));
        break;
        case "timestamp": entity.setTimestamp(java_lang_Long.demarshall(objVal, a1));
        break;
        case "type": entity.setType(java_lang_String.demarshall(objVal, a1));
        break;
        case "deploymentId": entity.setDeploymentId(java_lang_String.demarshall(objVal, a1));
        break;
        case "serverTemplateId": entity.setServerTemplateId(java_lang_String.demarshall(objVal, a1));
        break;
        case "id": entity.setId(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ProcessVariableSummary a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.pr.model.ProcessVariableSummary") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "variableId") + "\":") + java_lang_String.marshall(a0.getVariableId(), a1)) + ",\"") + "variableInstanceId") + "\":") + java_lang_String.marshall(a0.getVariableInstanceId(), a1)) + ",\"") + "processInstanceId") + "\":") + java_lang_Long.marshall(a0.getProcessInstanceId(), a1)) + ",\"") + "oldValue") + "\":") + java_lang_String.marshall(a0.getOldValue(), a1)) + ",\"") + "newValue") + "\":") + java_lang_String.marshall(a0.getNewValue(), a1)) + ",\"") + "timestamp") + "\":") + java_lang_Long.marshall(a0.getTimestamp(), a1)) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "deploymentId") + "\":") + java_lang_String.marshall(a0.getDeploymentId(), a1)) + ",\"") + "serverTemplateId") + "\":") + java_lang_String.marshall(a0.getServerTemplateId(), a1)) + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}