package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;

public class Marshaller_o_j_w_p_m_TimerInstanceSummary_1_Impl implements GeneratedMarshaller<TimerInstanceSummary> {
  private TimerInstanceSummary[] EMPTY_ARRAY = new TimerInstanceSummary[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public TimerInstanceSummary[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public TimerInstanceSummary demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TimerInstanceSummary.class, objId);
    }
    TimerInstanceSummary entity = new TimerInstanceSummary();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "timerId": entity.setTimerId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "activationTime": entity.setActivationTime(java_util_Date.demarshall(objVal, a1));
        break;
        case "lastFireTime": entity.setLastFireTime(java_util_Date.demarshall(objVal, a1));
        break;
        case "nextFireTime": entity.setNextFireTime(java_util_Date.demarshall(objVal, a1));
        break;
        case "delay": entity.setDelay(java_lang_Long.demarshall(objVal, a1));
        break;
        case "period": entity.setPeriod(java_lang_Long.demarshall(objVal, a1));
        break;
        case "repeatLimit": entity.setRepeatLimit(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "relative": entity.setRelative(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "processInstanceId": entity.setProcessInstanceId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "id": entity.setId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static Boolean TimerInstanceSummary_Boolean_relative(TimerInstanceSummary instance) /*-{
    return instance.@org.jbpm.workbench.pr.model.TimerInstanceSummary::relative;
  }-*/;

  native static void TimerInstanceSummary_Boolean_relative(TimerInstanceSummary instance, Boolean value) /*-{
    instance.@org.jbpm.workbench.pr.model.TimerInstanceSummary::relative = value;
  }-*/;

  public String marshall(TimerInstanceSummary a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.pr.model.TimerInstanceSummary") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "timerId") + "\":") + java_lang_Long.marshall(a0.getTimerId(), a1)) + ",\"") + "activationTime") + "\":") + java_util_Date.marshall(a0.getActivationTime(), a1)) + ",\"") + "lastFireTime") + "\":") + java_util_Date.marshall(a0.getLastFireTime(), a1)) + ",\"") + "nextFireTime") + "\":") + java_util_Date.marshall(a0.getNextFireTime(), a1)) + ",\"") + "delay") + "\":") + java_lang_Long.marshall(a0.getDelay(), a1)) + ",\"") + "period") + "\":") + java_lang_Long.marshall(a0.getPeriod(), a1)) + ",\"") + "repeatLimit") + "\":") + java_lang_Integer.marshall(a0.getRepeatLimit(), a1)) + ",\"") + "relative") + "\":") + java_lang_Boolean.marshall(TimerInstanceSummary_Boolean_relative(a0), a1)) + ",\"") + "processInstanceId") + "\":") + java_lang_Long.marshall(a0.getProcessInstanceId(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "id") + "\":") + java_lang_Long.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}