package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.pr.model.WorkItemSummary;

public class Marshaller_o_j_w_p_m_WorkItemSummary_1_Impl implements GeneratedMarshaller<WorkItemSummary> {
  private WorkItemSummary[] EMPTY_ARRAY = new WorkItemSummary[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public WorkItemSummary[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public WorkItemSummary demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(WorkItemSummary.class, objId);
    }
    WorkItemSummary entity = new WorkItemSummary();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "state": entity.setState(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "parameters": a1.setAssumedElementType("org.jbpm.workbench.pr.model.WorkItemParameterSummary");
        entity.setParameters(java_util_List.demarshall(objVal, a1));
        break;
        case "id": entity.setId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(WorkItemSummary a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.pr.model.WorkItemSummary") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "state") + "\":") + java_lang_Integer.marshall(a0.getState(), a1)) + ",\"") + "parameters") + "\":") + java_util_List.marshall(a0.getParameters(), a1)) + ",\"") + "id") + "\":") + java_lang_Long.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}