package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;

public class Marshaller_o_j_w_w_d_m_ItemObjectModel_1_Impl implements GeneratedMarshaller<ItemObjectModel> {
  private ItemObjectModel[] EMPTY_ARRAY = new ItemObjectModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public ItemObjectModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ItemObjectModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ItemObjectModel.class, objId);
    }
    ItemObjectModel entity = new ItemObjectModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "value": entity.setValue(java_lang_String.demarshall(objVal, a1));
        break;
        case "resolver": entity.setResolver(java_lang_String.demarshall(objVal, a1));
        break;
        case "parameters": a1.setAssumedElementType("org.jbpm.workbench.wi.dd.model.Parameter");
        entity.setParameters(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ItemObjectModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.wi.dd.model.ItemObjectModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + ",\"") + "resolver") + "\":") + java_lang_String.marshall(a0.getResolver(), a1)) + ",\"") + "parameters") + "\":") + java_util_List.marshall(a0.getParameters(), a1)) + "}");
  }

  private void lazyInit() {

  }
}