package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jbpm.workbench.wi.dd.model.Parameter;

public class Marshaller_o_j_w_w_d_m_Parameter_1_Impl implements GeneratedMarshaller<Parameter> {
  private Parameter[] EMPTY_ARRAY = new Parameter[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public Parameter[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Parameter demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Parameter.class, objId);
    }
    Parameter entity = new Parameter();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "type": entity.setType(java_lang_String.demarshall(objVal, a1));
        break;
        case "value": entity.setValue(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Parameter a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.jbpm.workbench.wi.dd.model.Parameter") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}