package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;

public class Marshaller_o_k_s_a_m_Message_1_Impl implements GeneratedMarshaller<Message> {
  private Message[] EMPTY_ARRAY = new Message[0];
  private Marshaller<Severity> org_kie_server_api_model_Severity = null;
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public Message[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Message demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Message.class, objId);
    }
    Message entity = new Message();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "severity": entity.setSeverity(objVal.isObject() != null ? Enum.valueOf(Severity.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Severity.class, objVal.isString().stringValue()) : null);
        break;
        case "timestamp": entity.setTimestamp(java_util_Date.demarshall(objVal, a1));
        break;
        case "messages": a1.setAssumedElementType("java.lang.String");
        entity.setMessages(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static List Message_List_messages(Message instance) /*-{
    return instance.@org.kie.server.api.model.Message::messages;
  }-*/;

  native static void Message_List_messages(Message instance, List<String> value) /*-{
    instance.@org.kie.server.api.model.Message::messages = value;
  }-*/;

  public String marshall(Message a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.server.api.model.Message") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "severity") + "\":") + (a0.getSeverity() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.server.api.model.Severity") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getSeverity().name()) + "\"}" : "null")) + ",\"") + "timestamp") + "\":") + java_util_Date.marshall(a0.getTimestamp(), a1)) + ",\"") + "messages") + "\":") + java_util_List.marshall(Message_List_messages(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_server_api_model_Severity == null) {
      org_kie_server_api_model_Severity = Marshalling.getMarshaller(Severity.class);
    }
  }
}