package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.server.controller.api.model.runtime.ContainerKey;

public class Marshaller_o_k_s_c_a_m_r_ContainerKey_1_Impl implements GeneratedMarshaller<ContainerKey> {
  private ContainerKey[] EMPTY_ARRAY = new ContainerKey[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ContainerKey[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ContainerKey demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ContainerKey.class, objId);
    }
    ContainerKey entity = new ContainerKey();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "serverTemplateId": entity.setServerTemplateId(java_lang_String.demarshall(objVal, a1));
        break;
        case "containerSpecId": entity.setContainerSpecId(java_lang_String.demarshall(objVal, a1));
        break;
        case "containerName": entity.setContainerName(java_lang_String.demarshall(objVal, a1));
        break;
        case "url": entity.setUrl(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ContainerKey a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.server.controller.api.model.runtime.ContainerKey") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "serverTemplateId") + "\":") + java_lang_String.marshall(a0.getServerTemplateId(), a1)) + ",\"") + "containerSpecId") + "\":") + java_lang_String.marshall(a0.getContainerSpecId(), a1)) + ",\"") + "containerName") + "\":") + java_lang_String.marshall(a0.getContainerName(), a1)) + ",\"") + "url") + "\":") + java_lang_String.marshall(a0.getUrl(), a1)) + "}");
  }

  private void lazyInit() {

  }
}