package org.jboss.errai.marshalling.client.api;

import java.util.Collection;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.runtime.Container;

public class Marshaller_o_k_s_c_a_m_r_Container_1_Impl implements GeneratedMarshaller<Container> {
  private Container[] EMPTY_ARRAY = new Container[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<ReleaseId> org_kie_server_api_model_ReleaseId = null;
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<KieContainerStatus> org_kie_server_api_model_KieContainerStatus = null;
  public Container[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Container demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Container.class, objId);
    }
    Container entity = new Container();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "serverInstanceId": entity.setServerInstanceId(java_lang_String.demarshall(objVal, a1));
        break;
        case "resolvedReleasedId": entity.setResolvedReleasedId(org_kie_server_api_model_ReleaseId.demarshall(objVal, a1));
        break;
        case "messages": entity.setMessages((Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "status": entity.setStatus(objVal.isObject() != null ? Enum.valueOf(KieContainerStatus.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(KieContainerStatus.class, objVal.isString().stringValue()) : null);
        break;
        case "serverTemplateId": entity.setServerTemplateId(java_lang_String.demarshall(objVal, a1));
        break;
        case "containerSpecId": entity.setContainerSpecId(java_lang_String.demarshall(objVal, a1));
        break;
        case "containerName": entity.setContainerName(java_lang_String.demarshall(objVal, a1));
        break;
        case "url": entity.setUrl(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Container a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.server.controller.api.model.runtime.Container") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "serverInstanceId") + "\":") + java_lang_String.marshall(a0.getServerInstanceId(), a1)) + ",\"") + "resolvedReleasedId") + "\":") + org_kie_server_api_model_ReleaseId.marshall(a0.getResolvedReleasedId(), a1)) + ",\"") + "messages") + "\":") + java_lang_Object.marshall(a0.getMessages(), a1)) + ",\"") + "status") + "\":") + (a0.getStatus() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.server.api.model.KieContainerStatus") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getStatus().name()) + "\"}" : "null")) + ",\"") + "serverTemplateId") + "\":") + java_lang_String.marshall(a0.getServerTemplateId(), a1)) + ",\"") + "containerSpecId") + "\":") + java_lang_String.marshall(a0.getContainerSpecId(), a1)) + ",\"") + "containerName") + "\":") + java_lang_String.marshall(a0.getContainerName(), a1)) + ",\"") + "url") + "\":") + java_lang_String.marshall(a0.getUrl(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_server_api_model_ReleaseId == null) {
      org_kie_server_api_model_ReleaseId = Marshalling.getMarshaller(ReleaseId.class);
    }
    if (org_kie_server_api_model_KieContainerStatus == null) {
      org_kie_server_api_model_KieContainerStatus = Marshalling.getMarshaller(KieContainerStatus.class);
    }
  }
}