package org.jboss.errai.marshalling.client.api;

import java.util.Collection;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.server.controller.api.model.runtime.ServerInstance;

public class Marshaller_o_k_s_c_a_m_r_ServerInstance_1_Impl implements GeneratedMarshaller<ServerInstance> {
  private ServerInstance[] EMPTY_ARRAY = new ServerInstance[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ServerInstance[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ServerInstance demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ServerInstance.class, objId);
    }
    ServerInstance entity = new ServerInstance();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "version": entity.setVersion(java_lang_String.demarshall(objVal, a1));
        break;
        case "messages": entity.setMessages((Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "containers": entity.setContainers((Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "serverInstanceId": entity.setServerInstanceId(java_lang_String.demarshall(objVal, a1));
        break;
        case "serverName": entity.setServerName(java_lang_String.demarshall(objVal, a1));
        break;
        case "serverTemplateId": entity.setServerTemplateId(java_lang_String.demarshall(objVal, a1));
        break;
        case "url": entity.setUrl(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ServerInstance a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.server.controller.api.model.runtime.ServerInstance") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((("" + ",\"") + "version") + "\":") + java_lang_String.marshall(a0.getVersion(), a1)) + ",\"") + "messages") + "\":") + java_lang_Object.marshall(a0.getMessages(), a1)) + ",\"") + "containers") + "\":") + java_lang_Object.marshall(a0.getContainers(), a1)) + ",\"") + "serverInstanceId") + "\":") + java_lang_String.marshall(a0.getServerInstanceId(), a1)) + ",\"") + "serverName") + "\":") + java_lang_String.marshall(a0.getServerName(), a1)) + ",\"") + "serverTemplateId") + "\":") + java_lang_String.marshall(a0.getServerTemplateId(), a1)) + ",\"") + "url") + "\":") + java_lang_String.marshall(a0.getUrl(), a1)) + "}");
  }

  private void lazyInit() {

  }
}