package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;

public class Marshaller_o_k_s_c_a_m_s_ContainerSpec_1_Impl implements GeneratedMarshaller<ContainerSpec> {
  private ContainerSpec[] EMPTY_ARRAY = new ContainerSpec[0];
  private Marshaller<ReleaseId> org_kie_server_api_model_ReleaseId = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller<KieContainerStatus> org_kie_server_api_model_KieContainerStatus = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ContainerSpec[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ContainerSpec demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ContainerSpec.class, objId);
    }
    ContainerSpec entity = new ContainerSpec();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "releasedId": entity.setReleasedId(org_kie_server_api_model_ReleaseId.demarshall(objVal, a1));
        break;
        case "configs": a1.setAssumedMapKeyType("org.kie.server.controller.api.model.spec.Capability");
        a1.setAssumedMapValueType("org.kie.server.controller.api.model.spec.ContainerConfig");
        entity.setConfigs(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "status": entity.setStatus(objVal.isObject() != null ? Enum.valueOf(KieContainerStatus.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(KieContainerStatus.class, objVal.isString().stringValue()) : null);
        break;
        case "id": entity.setId(java_lang_String.demarshall(objVal, a1));
        break;
        case "containerName": entity.setContainerName(java_lang_String.demarshall(objVal, a1));
        break;
        case "serverTemplateKey": entity.setServerTemplateKey((ServerTemplateKey) ((ObjectMarshaller) java_lang_Object).demarshall(ServerTemplateKey.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ContainerSpec a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.server.controller.api.model.spec.ContainerSpec") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "releasedId") + "\":") + org_kie_server_api_model_ReleaseId.marshall(a0.getReleasedId(), a1)) + ",\"") + "configs") + "\":") + java_util_Map.marshall(a0.getConfigs(), a1)) + ",\"") + "status") + "\":") + (a0.getStatus() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.server.api.model.KieContainerStatus") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getStatus().name()) + "\"}" : "null")) + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "containerName") + "\":") + java_lang_String.marshall(a0.getContainerName(), a1)) + ",\"") + "serverTemplateKey") + "\":") + java_lang_Object.marshall(a0.getServerTemplateKey(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_server_api_model_ReleaseId == null) {
      org_kie_server_api_model_ReleaseId = Marshalling.getMarshaller(ReleaseId.class);
    }
    if (org_kie_server_api_model_KieContainerStatus == null) {
      org_kie_server_api_model_KieContainerStatus = Marshalling.getMarshaller(KieContainerStatus.class);
    }
  }
}