package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.server.controller.api.model.spec.ProcessConfig;

public class Marshaller_o_k_s_c_a_m_s_ProcessConfig_1_Impl implements GeneratedMarshaller<ProcessConfig> {
  private ProcessConfig[] EMPTY_ARRAY = new ProcessConfig[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ProcessConfig[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ProcessConfig demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProcessConfig.class, objId);
    }
    ProcessConfig entity = new ProcessConfig();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "runtimeStrategy": entity.setRuntimeStrategy(java_lang_String.demarshall(objVal, a1));
        break;
        case "kBase": entity.setKBase(java_lang_String.demarshall(objVal, a1));
        break;
        case "kSession": entity.setKSession(java_lang_String.demarshall(objVal, a1));
        break;
        case "mergeMode": entity.setMergeMode(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ProcessConfig a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.server.controller.api.model.spec.ProcessConfig") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "runtimeStrategy") + "\":") + java_lang_String.marshall(a0.getRuntimeStrategy(), a1)) + ",\"") + "kBase") + "\":") + java_lang_String.marshall(a0.getKBase(), a1)) + ",\"") + "kSession") + "\":") + java_lang_String.marshall(a0.getKSession(), a1)) + ",\"") + "mergeMode") + "\":") + java_lang_String.marshall(a0.getMergeMode(), a1)) + "}");
  }

  private void lazyInit() {

  }
}