package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.controller.api.model.spec.RuleConfig;

public class Marshaller_o_k_s_c_a_m_s_RuleConfig_1_Impl implements GeneratedMarshaller<RuleConfig> {
  private RuleConfig[] EMPTY_ARRAY = new RuleConfig[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<KieScannerStatus> org_kie_server_api_model_KieScannerStatus = null;
  public RuleConfig[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RuleConfig demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RuleConfig.class, objId);
    }
    RuleConfig entity = new RuleConfig();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "pollInterval": entity.setPollInterval(java_lang_Long.demarshall(objVal, a1));
        break;
        case "scannerStatus": entity.setScannerStatus(objVal.isObject() != null ? Enum.valueOf(KieScannerStatus.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(KieScannerStatus.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(RuleConfig a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.server.controller.api.model.spec.RuleConfig") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "pollInterval") + "\":") + java_lang_Long.marshall(a0.getPollInterval(), a1)) + ",\"") + "scannerStatus") + "\":") + (a0.getScannerStatus() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.server.api.model.KieScannerStatus") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getScannerStatus().name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_kie_server_api_model_KieScannerStatus == null) {
      org_kie_server_api_model_KieScannerStatus = Marshalling.getMarshaller(KieScannerStatus.class);
    }
  }
}