package org.jboss.errai.marshalling.client.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;

public class Marshaller_o_k_s_c_a_m_s_ServerTemplate_1_Impl implements GeneratedMarshaller<ServerTemplate> {
  private ServerTemplate[] EMPTY_ARRAY = new ServerTemplate[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<KieServerMode> org_kie_server_api_model_KieServerMode = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ServerTemplate[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Collection ServerTemplate_Collection_serverInstances(ServerTemplate instance) /*-{
    return instance.@org.kie.server.controller.api.model.spec.ServerTemplate::serverInstances;
  }-*/;

  native static void ServerTemplate_Collection_serverInstances(ServerTemplate instance, Collection<ServerInstanceKey> value) /*-{
    instance.@org.kie.server.controller.api.model.spec.ServerTemplate::serverInstances = value;
  }-*/;

  public ServerTemplate demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ServerTemplate.class, objId);
    }
    ServerTemplate entity = new ServerTemplate();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "containersSpec": entity.setContainersSpec((Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "configs": a1.setAssumedMapKeyType("org.kie.server.controller.api.model.spec.Capability");
        a1.setAssumedMapValueType("org.kie.server.controller.api.model.spec.ServerConfig");
        entity.setConfigs(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "serverInstances": ServerTemplate_Collection_serverInstances(entity, (Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "capabilities": a1.setAssumedElementType("java.lang.String");
        entity.setCapabilities(java_util_List.demarshall(objVal, a1));
        break;
        case "mode": entity.setMode(objVal.isObject() != null ? Enum.valueOf(KieServerMode.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(KieServerMode.class, objVal.isString().stringValue()) : null);
        break;
        case "id": entity.setId(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ServerTemplate a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.server.controller.api.model.spec.ServerTemplate") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((("" + ",\"") + "containersSpec") + "\":") + java_lang_Object.marshall(a0.getContainersSpec(), a1)) + ",\"") + "configs") + "\":") + java_util_Map.marshall(a0.getConfigs(), a1)) + ",\"") + "serverInstances") + "\":") + java_lang_Object.marshall(ServerTemplate_Collection_serverInstances(a0), a1)) + ",\"") + "capabilities") + "\":") + java_util_List.marshall(a0.getCapabilities(), a1)) + ",\"") + "mode") + "\":") + (a0.getMode() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.server.api.model.KieServerMode") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getMode().name()) + "\"}" : "null")) + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_server_api_model_KieServerMode == null) {
      org_kie_server_api_model_KieServerMode = Marshalling.getMarshaller(KieServerMode.class);
    }
  }
}