package org.jboss.errai.marshalling.client.api;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;

public class Marshaller_o_k_s_p_d_i_Imports_1_Impl implements GeneratedMarshaller<Imports> {
  private Imports[] EMPTY_ARRAY = new Imports[0];
  private Marshaller<ArrayList> java_util_ArrayList = null;
  public Imports[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static ArrayList Imports_ArrayList_imports(Imports instance) /*-{
    return instance.@org.kie.soup.project.datamodel.imports.Imports::imports;
  }-*/;

  native static void Imports_ArrayList_imports(Imports instance, ArrayList<Import> value) /*-{
    instance.@org.kie.soup.project.datamodel.imports.Imports::imports = value;
  }-*/;

  public Imports demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Imports.class, objId);
    }
    Imports entity = new Imports();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "imports": a1.setAssumedElementType("org.kie.soup.project.datamodel.imports.Import");
        Imports_ArrayList_imports(entity, java_util_ArrayList.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Imports a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.soup.project.datamodel.imports.Imports") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "imports") + "\":") + java_util_ArrayList.marshall(Imports_ArrayList_imports(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (java_util_ArrayList == null) {
      java_util_ArrayList = Marshalling.getMarshaller(ArrayList.class);
    }
  }
}