package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.oracle.Annotation;

public class Marshaller_o_k_s_p_d_o_Annotation_1_Impl implements GeneratedMarshaller<Annotation> {
  private Annotation[] EMPTY_ARRAY = new Annotation[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public Annotation[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String Annotation_String_qualifiedTypeName(Annotation instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.Annotation::qualifiedTypeName;
  }-*/;

  native static void Annotation_String_qualifiedTypeName(Annotation instance, String value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.Annotation::qualifiedTypeName = value;
  }-*/;

  native static Map Annotation_Map_parameters(Annotation instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.Annotation::parameters;
  }-*/;

  native static void Annotation_Map_parameters(Annotation instance, Map value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.Annotation::parameters = value;
  }-*/;

  public Annotation demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Annotation.class, objId);
    }
    Annotation entity = new Annotation();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "qualifiedTypeName": Annotation_String_qualifiedTypeName(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "parameters": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.Object");
        Annotation_Map_parameters(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
      }
    }
    return entity;
  }

  public String marshall(Annotation a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.soup.project.datamodel.oracle.Annotation") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "qualifiedTypeName") + "\":") + java_lang_String.marshall(a0.getQualifiedTypeName(), a1)) + ",\"") + "parameters") + "\":") + java_util_Map.marshall(a0.getParameters(), a1)) + "}");
  }

  private void lazyInit() {

  }
}