package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.oracle.DataType;

public class Marshaller_o_k_s_p_d_o_DataType_1_Impl implements GeneratedMarshaller<DataType> {
  private DataType[] EMPTY_ARRAY = new DataType[0];
  public DataType[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DataType demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataType.class, objId);
    }
    DataType entity = new DataType();
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(DataType a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.soup.project.datamodel.oracle.DataType") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + (((("" + ",\"") + "^InstantiateOnly") + "\":true") + "}");
  }

  private void lazyInit() {

  }
}